package simpleTypes;

public class SumExample {
	
	// this is close to a sum type, but NOT really (int + String)
	static interface Int_String_Sum {}
	
	static class In_Int implements Int_String_Sum {
		int i;
		In_Int(int i) {
			this.i = i;
		}
	}

	static class In_String implements Int_String_Sum {
		String s;
		In_String(String s) {
			this.s = s;
		}
	}
	
	public static void main(String[] args) {
		
		// introduction
		Int_String_Sum x1 = new In_Int(5);
		Int_String_Sum x2 = new In_String("shrdlu");
		
		// elimination
		
		// This is *really* horrible code, according to the principles of
		// object-oriented programming!
		if (x1 instanceof In_Int) {
			In_Int o = (In_Int) x1;
			System.out.println("In_Int: " + o.i);
		} else if (x1 instanceof In_String) {
			In_String o = (In_String) x1;
			System.out.println("In_String: " + o.s);
		}
		
		if (x2 instanceof In_Int) {
			In_Int o = (In_Int) x2;
			System.out.println("In_Int: " + o.i);
		} else if (x2 instanceof In_String) {
			In_String o = (In_String) x2;
			System.out.println("In_String: " + o.s);
		}
		
		/*
		 * Main issues:
		 * 
		 * 1) The type-checker does not verify that we handle *all* the subclasses of
		 * Int_String_Sum. We might forget some case in the sum.
		 * 
		 * 2) Type casts like "(In_Int) x1" are very dangerous operations: they can crash
		 * the whole program if "x1" is found to be of an incompatible type. The burden
		 * is on the programmer to check that "x1" is of the right type before evaluating
		 * the type cast. This is done using "instanceof".
		 * 
		 * 3) The philosophy underlying Object-Oriented Programming is very against these
		 * "tricks". OOP should work in a "open world", where e.g. every interface (like 
		 * the type "Int_String_Sum") should always be open to future implementations
		 * through classes. That is, good OOP code should not handle each subclass as done
		 * above, since it will break as soon as a new class implementing the interface
		 * is added. This is related to point 1) above.
		 * 
		 * 
		 */

	}

}
